/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.util.IBellowsConsumerBlock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.te.TEBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class TEBellows
extends TEBase {
    public static final Vec3i OFFSET_LEVEL = new Vec3i(1, 0, 0);
    public static final Vec3i OFFSET_INSET = new Vec3i(1, -1, 0);
    private static final Set<Vec3i> OFFSETS = new HashSet<Vec3i>();
    private static final int BELLOWS_AIR = ConfigTFC.Devices.BELLOWS.ticks;
    private long lastPushed = 0L;

    public static void addBellowsOffset(Vec3i offset) {
        OFFSETS.add(offset);
    }

    @SideOnly(value=Side.CLIENT)
    public double getHeight() {
        int time = (int)(this.field_145850_b.func_82737_E() - this.lastPushed);
        if (time < 10) {
            return (double)time * 0.05 + 0.125;
        }
        if (time < 20) {
            return (double)(20 - time) * 0.05 + 0.125;
        }
        return 0.125;
    }

    public boolean onRightClick() {
        long time = this.field_145850_b.func_82737_E() - this.lastPushed;
        if (time < 20L) {
            return true;
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, TFCSounds.BELLOWS_BLOW_AIR, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!this.field_145850_b.field_72995_K) {
            this.lastPushed = this.field_145850_b.func_82737_E();
            this.markForBlockUpdate();
        }
        EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        for (Vec3i offset : OFFSETS) {
            BlockPos posx = this.field_174879_c.func_177981_b(offset.func_177956_o()).func_177967_a(direction, offset.func_177958_n()).func_177967_a(direction.func_176746_e(), offset.func_177952_p());
            Block block = this.field_145850_b.func_180495_p(posx).func_177230_c();
            if (!(block instanceof IBellowsConsumerBlock) || !((IBellowsConsumerBlock)block).canIntakeFrom(offset, direction)) continue;
            ((IBellowsConsumerBlock)block).onAirIntake(this.field_145850_b, posx, BELLOWS_AIR);
            if (this.field_145850_b.field_72995_K) {
                posx = this.field_174879_c.func_177972_a(direction);
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)posx.func_177958_n() + 0.5, (double)posx.func_177956_o() + 0.5, (double)posx.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return true;
    }

    public void debug() {
        TerraFirmaCraft.getLog().debug("Debugging Bellows");
        TerraFirmaCraft.getLog().debug("Now: {} | Then: {} | Difference: {}", (Object)this.field_145850_b.func_82737_E(), (Object)this.lastPushed, (Object)(this.field_145850_b.func_82737_E() - this.lastPushed));
        TerraFirmaCraft.getLog().debug("Total Height: {}", (Object)this.getHeight());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.lastPushed = nbt.func_74763_f("lastPushed");
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("lastPushed", this.lastPushed);
        return super.func_189515_b(nbt);
    }

    static {
        TEBellows.addBellowsOffset(OFFSET_LEVEL);
        TEBellows.addBellowsOffset(OFFSET_INSET);
    }
}

